//////////////////////////////////////////////
// main.cpp
//
//////////////////////////////////////////////

/// Includes ---------------------------------

// nkLog
#include <NilkinsLog/Loggers/ConsoleLogger.h>

// nkGraphics
#include <NilkinsGraphics/Configurations/Configuration.h>

#include <NilkinsGraphics/Log/LogManager.h>

#include <NilkinsGraphics/RenderContexts/RenderContextDescriptor.h>
#include <NilkinsGraphics/RenderContexts/RenderContextManager.h>

#include <NilkinsGraphics/System.h>

// nkResources
#include <NilkinsResources/ResourceManager.h>

// Standards
#include <memory>

/// Function ---------------------------------

int main ()
{
	// Prepare logging
	std::unique_ptr<nkLog::Logger> logger = std::make_unique<nkLog::ConsoleLogger>() ;
	nkGraphics::LogManager::getInstance()->setReceiver(logger.get()) ;

	// We will change a bit the configuration, to alter how the engine will initialize
	nkGraphics::Configuration config ;

	// We will use the Dx11 API this time (defaults to AUTOMATIC, often resulting in using Dx12)
	config.setWantedApi(nkGraphics::RENDERING_API::D3D11) ;

	// Set the path we will use to find back the data, relative to execution path
	// Now setting a resourcePath in a resource will be relative to the Data folder
	nkResources::ResourceManager::getInstance()->setWorkingPath("Data") ;

	// Init the component, using all the configuration we made up till now
	if (!nkGraphics::System::getInstance()->initialize(config))
		return -1 ;

	// Prepare the context and window we will use
	nkGraphics::RenderContextDescriptor contextDescriptor (1280, 1024, false, true) ;
	nkGraphics::RenderContext* context = nkGraphics::RenderContextManager::getInstance()->createRenderContext(contextDescriptor) ;

	// Run and clean once done
	// REGION_CPP
	nkGraphics::System::getInstance()->run(context) ;

	// Clean
	nkGraphics::System::getInstance()->kill() ;

	return 0 ;
}